% train: Learn reflectance statistics from training set
%
% train(lst,saveloc,true_l)
%
%   lst:     Cell (Nx1) containing paths of pre-computed statistics files
%   saveloc: Path of output .mat file
%   true_l:  (OPTIONAL) Nx3 Array containing ground truth illuminants 
%            for each file. If this parameter is ommitted, all illuminants
%            will be assumed to be [1 1 1].
function train(lst,saveloc,true_l)
  
  fouts = loadpc(lst{1});
  
  num_bands = length(fouts);
  
  
  if nargin == 2
    true_l = ones(length(lst),3);
  end;

  cov_o = repmat(diag([1 1 1]),[1 1 num_bands]);
  skip = [10 10 10 10 1];
  if length(lst) < 200
    skip(:) = 1;
  end;
  for outer_iters = 1:length(skip)
    % Go through training set
    
    cov_t = zeros(3,3,num_bands);
    numt_t = zeros(1,1,num_bands);
    for i = 1:skip(outer_iters):length(lst)
      fprintf('\r %d) File %d of %d         ',outer_iters,i,length(lst));
      fouts = loadpc(lst{i});
    
      % Find normalization
      l = 1 ./ true_l(i,:); l = l / max(l(:));
      
      for k = 1:num_bands
        d = fouts{k}; d = d .* repmat(l,[size(d,1) 1]);
        
        wts = sum(d .* (d * cov_o(:,:,k)),2);
        d = d ./ repmat(max(10^-24,wts.^(0.25)),[1 3]);
        
        numt_t(k) = numt_t(k) + size(d,1);
        cov_t(:,:,k) = cov_t(:,:,k) + d'*d;
      end;
    
    end;
    fprintf('\n');
  
    cov_t = cov_t ./ repmat(numt_t,[3 3 1]) * 4;
    % Find eigen vectors
    for k = 1:num_bands
%       [v,d] = eig(cov_t(:,:,k));
%       [d idx] = sort(diag(d));
%       v = v(:,idx);
      %fprintf('[%d: %1.2f d, %1.2f]',k,acosd(abs(sum(v(:,3)/sqrt(3)))),max(d) / sum(d));
      cov_t(:,:,k) = inv(cov_t(:,:,k));
    end;
    fprintf('\n'); 
    cov_o = cov_t;
  end;
  
  %fprintf('\n* Saving training data to %s ..\n',saveloc);
  save('-mat',saveloc,'cov_t');
    